/*
	File:		BevelDialog.cp

	Contains:	Bevel Button examples dialog.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

//
//	This file implements a simple dialog which shows a myriad of bevel
//	button possibilities. Even with all it shows, it does not show all
//	the possible variations.
//

#include <Fonts.h>
#include <Controls.h>
#include "BevelDialog.h"
#include "Appearance.h"
#include "AppearanceHelpers.h"

void	HandleBevelDialog( DialogPtr dialog, short itemHit );

void	EnableDisableAll( DialogPtr dialog, Boolean enable );
void	SetControlValues( DialogPtr dialog, short value );
void	SetUpBevelDialog( DialogPtr dialog );


enum {
	kDisableButton		= 1,
	kEnableButton		= 2,
	kOnButton			= 3,
	kOffButton			= 4,
	kMixedButton		= 5,
	kFirstButton 		= 6,
	kLastButton 		= 32
};

BevelDialog::BevelDialog() : BaseDialog( 1001 )
{
	GrafPtr			savePort;
	ControlHandle	control;
	
	if ( fWindow )
	{
		GetPort( &savePort );
		SetPort( fWindow );
		TextFont( applFont );
		TextSize( 10 );
		SetPort( savePort );


			// This next bit of code sets one of our bevel buttons up to
			// make the text always appear 0 pixels from the edge in an
			// internationalized fashion, i.e. in left-to-right scripts
			// it will be placed starting 0 pixels from the left.
			// In right-to-left scripts it will be 0 pixels in from the
			// right.
			
		GetDialogItemAsControl( fWindow, 18, &control );	
		SetBevelButtonTextAlignment( control, kControlBevelButtonAlignTextFlushLeft, 0 );
		GetDialogItemAsControl( fWindow, 19, &control );	
		SetBevelButtonTextAlignment( control, kControlBevelButtonAlignTextFlushLeft, 0 );
		GetDialogItemAsControl( fWindow, 20, &control );	
		SetBevelButtonTextAlignment( control, kControlBevelButtonAlignTextFlushRight, 0 );
		GetDialogItemAsControl( fWindow, 21, &control );	
		SetBevelButtonTextAlignment( control, kControlBevelButtonAlignTextFlushLeft, 5 );

			// This code sets up some of the buttons to align the text
			// and graphics so they fit together side by side (or above
			// each other).
			
		GetDialogItemAsControl( fWindow, 26, &control );
		SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceToRightOfGraphic );
		GetDialogItemAsControl( fWindow, 27, &control );
		SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceToLeftOfGraphic );
		GetDialogItemAsControl( fWindow, 28, &control );
		SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceBelowGraphic );
		GetDialogItemAsControl( fWindow, 29, &control );
		SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceAboveGraphic );
		GetDialogItemAsControl( fWindow, 30, &control );
		SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceSysDirection );
		SetBevelButtonGraphicAlignment( control, kControlBevelButtonAlignSysDirection, 0, 0 );

		GetDialogItemAsControl( fWindow, 31, &control );
		SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceToRightOfGraphic );
		SetBevelButtonGraphicAlignment( control, kControlBevelButtonAlignLeft, 2, 0 );

		GetDialogItemAsControl( fWindow, 32, &control );
		SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceToLeftOfGraphic );
		SetBevelButtonGraphicAlignment( control, kControlBevelButtonAlignRight, 2, 0 );


		ShowWindow( fWindow );
	}
}

BevelDialog::~BevelDialog()
{
}

void
BevelDialog::HandleItemHit( short itemHit )
{
	switch ( itemHit ) {
		case kDisableButton:
			EnableDisableAll( false );
			break;
		
		case kEnableButton:
			EnableDisableAll( true );
			break;
		
		case kOnButton:
			SetControlValues( kControlCheckBoxCheckedValue );
			break;
		
		case kOffButton:
			SetControlValues( kControlCheckBoxUncheckedValue );
			break;
		
		case kMixedButton:
			SetControlValues( kControlCheckBoxMixedValue );
			break;
			
	}
}

void
BevelDialog::EnableDisableAll( Boolean enable )
{
	short		theType;
	Handle		theHand;
	Rect		theRect;
	short		i;
	
	for ( i = kFirstButton; i <= kLastButton; i++ ) {
		GetDialogItem( fWindow, i, &theType, &theHand, &theRect );
		HiliteControl( (ControlHandle)theHand, enable ? 0 : kControlInactivePart );
	}
}

void
BevelDialog::SetControlValues( short value )
{
	short		theType;
	Handle		theHand;
	Rect		theRect;
	short		i;
	
	for ( i = kFirstButton; i <= kLastButton; i++ ) {
		GetDialogItem( fWindow, i, &theType, &theHand, &theRect );
		SetControlValue( (ControlHandle)theHand, value );
	}
}
